<?php
// Datubāzes konfigurācija
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "quiz_db";

// Izveido savienojumu
$conn = new mysqli($servername, $username, $password, $dbname);

// Pārbauda savienojumu
if ($conn->connect_error) {
    die("Savienojums neizdevās: " . $conn->connect_error);
}

// Iegūst testa ID no pieprasījuma
$testId = isset($_GET['id']) ? $_GET['id'] : null;

if ($testId) {
    echo "Testa ID: " . $testId . "<br>";

    // Sagatavo un saista
    $stmt = $conn->prepare("DELETE FROM tests WHERE id = ?");
    $stmt->bind_param("i", $testId);

    // Izpilda paziņojumu
    if ($stmt->execute()) {
        echo "Tests veiksmīgi dzēsts<br>";
        // Iestata atbildes datus
        $response = array(
            'success' => true
        );
    } else {
        echo "Neizdevās dzēst testu: " . $stmt->error . "<br>";
        // Iestata kļūdas atbildi
        $response = array(
            'success' => false,
            'error' => 'Neizdevās dzēst testu: ' . $stmt->error
        );
    }

    // Aizver paziņojumu
    $stmt->close();
} else {
    // Iestata kļūdas atbildi, ja testa ID nav norādīts
    echo "Nav norādīts tests ID<br>";
    $response = array(
        'success' => false,
        'error' => 'Nav norādīts tests ID'
    );
}

// Aizver savienojumu
$conn->close();

// Iestata atbildes galvenes, lai norādītu JSON saturu
header('Content-Type: application/json');

// Izvada atbildi kā JSON
echo json_encode($response);

// Pāradresē uz testu_parvaldīšana.html, ja tests ir veiksmīgi dzēsts
if ($response['success']) {
    header('Location: ../html/testu_parvaldisana.html');
    exit();
}
?>
